<?php
/*
                         ''~``
                        ( o o )
+------------------.oooO--(_)--Oooo.------------------+
|                    Unreal Portal                    |
|                    .oooO                            |
|                    (   )   Oooo.                    |
+---------------------\ (----(   )--------------------+
                       \_)    ) /
                             (_/


           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
           |The Logo Looks Best in Courier New|
           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

                       ---====---
                      Unreal Portal
                       By Cricket
*/

class class_calendar
{
    protected $registry;
    protected $DB;
    protected $settings;
    protected $request;
    protected $lang;
    protected $member;
    protected $cache;
    protected $caches;
    var $globals;

    public function __construct( ipsRegistry $registry )
    {
        /* Make object */
        $this->registry   = $registry;
        $this->DB         = $this->registry->DB();
        $this->settings   =& $this->registry->fetchSettings();
        $this->request    =& $this->registry->fetchRequest();
        $this->lang       = $this->registry->getClass('class_localization');
        $this->member     = $this->registry->member();
        $this->memberData =& $this->registry->member()->fetchMemberData();
        $this->cache      =  $this->registry->cache();
        $this->caches     =& $this->registry->cache()->fetchCaches();
    }

    /*
     * Stole most of the code from IPB Portal. Thanks IPB for making me copy-paste rather than having all this code as part of a function in the calendar class itself
     */
    function show_calendar()
    {
        //-----------------------------------------
        // Grab calendar class
        //-----------------------------------------
        
        require_once( IPSLib::getAppDir( 'calendar', 'calendar' ) . '/calendars.php' );
        $calendar = new public_calendar_calendar_calendars();
        $calendar->makeRegistryShortcuts( $this->registry );

        //-----------------------------------------
        // Load lang and templs
        //-----------------------------------------
        
        ipsRegistry::getClass( 'class_localization')->loadLanguageFile( array( 'public_calendar' ) );

        //-----------------------------------------
        // DO some set up
        //-----------------------------------------
        
        $calendar->calendar_id = 1; // CHANGE TO DEFAULT?
        
        if( ! count( $this->caches['calendars'] ) )
        {
            $cache  = array();
            
            $this->DB->build( array( 
                                    'select'    => 'c.*', 
                                    'from'      => array( 'cal_calendars' => 'c' ), 
                                    'add_join'  => array(
                                                        array(
                                                                'select'    => 'p.*',
                                                                'from'      => array( 'permission_index' => 'p' ),
                                                                'where'     => "p.perm_type='calendar' AND perm_type_id=c.cal_id",
                                                                'type'      => 'left',
                                                            )
                                                        )   
                        )   );
            $this->DB->execute();
            
            while( $cal = $this->DB->fetch() )
            {
                $cache[ $cal['cal_id'] ] = $cal;
            }
            
            $this->cache->setCache( 'calendars', $cache, array( 'array' => 1, 'deletefirst' => 1 ) );
        }
        
        /* Calendar Cache */            
        if( count( $this->caches['calendars'] ) AND is_array( $this->caches['calendars'] ) )
        {
            foreach($this->caches['calendars'] as $cal_id => $cal )
            {
                $selected = "";
                
                /* Got a perm */
                if( ! $this->registry->permissions->check( 'view', $cal ) )
                {
                    continue;
                }
                                
                if ( $cal['cal_id'] == $calendar->calendar_id )
                {
                    $calendar->calendar = $cal;
                    $selected           = " selected='selected'";
                }
                
                $calendar->calendar_cache[ $cal['cal_id'] ] = $cal;
            }
        }
        
        if( ! $calendar->calendar )
        {
            if( count( $calendar->calendar_cache ) )
            {
                $tmp_resort = $calendar->calendar_cache;
                ksort($tmp_resort);
                reset($tmp_resort);
                $default_calid = key( $tmp_resort );
                $calendar->calendar_id = $default_calid;
                $calendar->calendar = $tmp_resort[ $default_calid ];
                unset( $tmp_resort );
            }
        }
        
        $calendar->calendarBuildPermissions();
        
        if( !is_array($calendar->calendar) OR !count($calendar->calendar) OR !$calendar->can_read )
        {
            return'';
        }

        //-----------------------------------------
        // Finally, build up the lang arrays
        //-----------------------------------------
        
        $calendar->month_words = array( $this->lang->words['M_1'] , $this->lang->words['M_2'] , $this->lang->words['M_3'] ,
                                        $this->lang->words['M_4'] , $this->lang->words['M_5'] , $this->lang->words['M_6'] ,
                                        $this->lang->words['M_7'] , $this->lang->words['M_8'] , $this->lang->words['M_9'] ,
                                        $this->lang->words['M_10'], $this->lang->words['M_11'], $this->lang->words['M_12'] );
                                    
        if( !$this->settings['ipb_calendar_mon'] )
        {
            $calendar->day_words   = array( $this->lang->words['D_0'], $this->lang->words['D_1'], $this->lang->words['D_2'],
                                        $this->lang->words['D_3'], $this->lang->words['D_4'], $this->lang->words['D_5'],
                                        $this->lang->words['D_6'] );
        }
        else
        {
            $calendar->day_words   = array( $this->lang->words['D_1'], $this->lang->words['D_2'], $this->lang->words['D_3'],
                                        $this->lang->words['D_4'], $this->lang->words['D_5'], $this->lang->words['D_6'],
                                        $this->lang->words['D_0'] );
        }
        
        //-----------------------------------------
        // What now?
        //-----------------------------------------
        
        $a = explode( ',', gmdate( 'Y,n,j,G,i,s', time() + ipsRegistry::getClass( 'class_localization')->getTimeOffset() ) );
        
        $now_date = array(
                          'year'    => $a[0],
                          'mon'     => $a[1],
                          'mday'    => $a[2],
                          'hours'   => $a[3],
                          'minutes' => $a[4],
                          'seconds' => $a[5]
                        );

        $cal_output = $calendar->getMonthEvents( $now_date['mon'], $now_date['year'], 1 );

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['calendar'], "calendar");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->mini_cal_mini_wrap( $calendar->month_words[ $month - 1 ], $now_date['mon'], $now_date['year'], $cal_output, $calendar->day_words );
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();
        
        return $to_return;
    }
}

?>